package jamezo97.clonecraft.entity.clone;

import jamezo97.clonecraft.network.Handler5UpdateOneOption;
import net.minecraft.entity.player.EntityPlayer;

public class CloneOption {
	
	String name;
	int id;
	boolean value;
	boolean defaultValue;
	
	CloneOptions optionsInstance;
	
	public CloneOption(String name, int id, boolean defaultValue, CloneOptions optionsInstance){
		this.name = name;
		this.id = id;
		this.value = defaultValue;
		this.defaultValue = defaultValue;
		this.optionsInstance = optionsInstance;
	}
	
	public void updateOptionToAllWatching(){
		createPacket().sendToAllWatching(optionsInstance.clone);
	}
	
	public void updateToClient(EntityPlayer client){
		createPacket().sendToClient(client);
	}
	
	public void updateToServer(){
		createPacket().sendToServer();
	}
	
	private Handler5UpdateOneOption createPacket(){
		return new Handler5UpdateOneOption(optionsInstance.clone.entityId, id, value, optionsInstance.clone.worldObj.provider.dimensionId);
	}

	public boolean value(){
		return value;
	}
	
	public String getName(){
		return name;
	}
	
	public void set(boolean b){
		value = b;
	}
	
	public int getId(){
		return id;
	}

	public void updateOptionToAllPlayers(EntityPlayer[] players) {
		if(players != null){
			for(int a = 0; a < players.length; a++){
				if(players[a] != null){
					updateToClient(players[a]);
				}
			}
		}
	}

}
